### Are you having issues with Mosaico?

Please make sure:
- you understand you have to build it and to run a backend server (either the node.js version bundled with this project or the php backend referenced above or write your own)
- you read this Readme *three* times and followed the instructions
- you understand I'll close any GitHub issue with insufficient information: if you want help then you'll have to take your time to explain your issue.
- you don't ask for a binary/executable to be used as a standalone desktop application
- you understand you can't simply open index.html/editor.html and expect it to work if you don't build the library and don't run a backend server and access that files through the webserver.
- you don't add off topic comments to an existing issue: if you want to add that you are having the same issue please make sure you are having the same issue described. If you are unsure, open a new issue following the rules (we prefer a duplicated issue than a chaotic issue mixing unrelated things).

##### issues building:
- take note of the full log of your npm install, and grunt commands output
- open a GitHub issues saying that you read this doc
- paste the output from npm install and grunt
- write your full environment (your operative system name and version, your node version, your npm version)

##### issues running/editing
if your problem is not with the building then when you open a GitHub issue:
- make sure you specify if you are using the bundled backend or php backend or any other kind of deployment
- tell us the browser you are using (name and version) and test at least a *second* browser to tell us if this happen in both or only one (tell us the details about the second browser too).
- test the same scenario on https://mosaico.io and tell us if you see the same issue
- if you are having issues running with Apache then specify you installed the php backend from access interpreting and WHY you think you are having problem with mosaico.js and not with that specific backend (did you try with bundled node.js backend?)

##### rendering issues with templates generated by Mosaico
- open an issue only if you have a screenshot
- when you open an issue please tell us what template you are using
- tell which email client show the issue (version, name, operative system)
- tell us which backend you are using (the bundled one ran with grunt, the php backend referenced above, or your custom backend).
- if you are sending the email using a different way then most of the times the template gets broken by your way to send it: so try the same thing on mosaico.io and confirm you see the same rendering issues.

### Want to contribute code?

Open an Issue, first, and coordinate with us.
